type AmOrPm = "AM" | "am" | "Am" | "PM" | "pm" | "Pm"
// type Digit = '0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9'

export type OtpTime = `${number}:${number}${AmOrPm}` //`${Digit}${Digit}:${Digit}${Digit}${AmOrPm}`

/**
 * Time stand separated by '-' in the format 'Month-Day-Year' when locale is set to 'en'.
 */
export type OtpDate = `${number}-${number}-${number}`

export type OtpLocal = 'en_US';

/**
 * @deprecated ONLY USED FOR REST API
 */
type OtpFlexModeLegacy =
  | "FLEX_DIRECT"
  | "FLEX_ACCESS"
  | "FLEX_EGRESS"

type OtpFlexMode =
  OtpFlexModeLegacy
  | "FLEX"

/**
 * All available transit modes provided by OTP
 */
type OtpModeInternal =
  | OtpFlexMode
  | "WALK"
  | "TRANSIT"
  | "CAR"
  | "BUS"
  | "TAXI"
  | "MONORAIL"
  | "CARPOOL"
  | "BICYCLE"
  | "BICYCLE_RENT"
  | "BICYCLE_PARK"
  | "CAR"
  | "CAR_PARK"
  | "TRAM"
  | "SUBWAY"
  | "RAIL"
  | "BUS"
  | "CABLE_CAR"
  | "FERRY"
  | "GONDOLA"
  | "FUNICULAR"
  | "AIRPLANE"

export type OtpModeParams = {
  mode: OtpMode | OtpModeCombination,
  qualifier?: OtpQualifier,
}

export type OtpQualifier =
  | "RENT"
  | "PARK"
  /**
   * @deprecated CURRENTLY NOT USED
  */
  | "KEEP"
  /**
    * @deprecated CURRENTLY NOT USED
    */
  | "HAVE"
  | "PICKUP"
  | "DROPOFF"
  | "ACCESS"
  | "EGRESS"
  | "DIRECT"
  | "HAIL"


export type OtpMode = Extract<
  OtpModeInternal,
  | OtpFlexMode
  | "WALK"
  | "TRANSIT"
  | "CAR"
  | "BUS"
  | "TAXI"
  | "MONORAIL"
  | "CARPOOL"
  | "FERRY"
>

export type OtpModeCombination =
  | `${OtpMode},${OtpMode}`
  | `${OtpMode},${OtpMode},${OtpMode}`
  | `${OtpMode},${OtpMode},${OtpMode},${OtpMode}`

export type OtpOptimze =
  | "FLAT"
  | "GREENWAYS"
  | "QUICK"
  | "SAFE"
  | "TRIANGLE"